<p align="center">
    <img src="https://github.com/IDI-Systems/acre2/blob/master/extras/logos/acre2-small-logo.png">
</p>

<p align="center">
    <a href="https://github.com/IDI-Systems/acre2/releases/latest">
        <img src="https://img.shields.io/badge/Version-2.13.1-blue.svg?style=flat-square" alt="ACRE2 Version">
    </a>
    <a href="https://github.com/IDI-Systems/acre2/issues">
        <img src="https://img.shields.io/github/issues-raw/IDI-Systems/acre2.svg?style=flat-square&label=Issues" alt="ACRE2 Issues">
    </a>
    <a href="https://forums.bistudio.com/topic/193813-acre2-v22-stable-steam-workshop-release">
        <img src="https://img.shields.io/badge/BIF-Thread-lightgrey.svg?style=flat-square" alt="BIF Thread">
    </a>
    <a href="https://github.com/IDI-Systems/acre2/blob/master/LICENSE">
        <img src="https://img.shields.io/badge/License-GPLv3-red.svg?style=flat-square" alt="ACRE2 License">
    </a>
    <a href="https://acre2.idi-systems.com">
        <img src="https://img.shields.io/badge/Documentation-Home-lightgrey.svg?style=flat-square" alt="ACRE2 Wiki">
    </a>
    <a href="https://acemod.org/discord">
        <img src="https://img.shields.io/badge/Discord-Join%20%23acre2-darkviolet.svg?style=flat-square" alt="ACE Discord">
    </a>
    <a href="https://github.com/IDI-Systems/acre2/actions/workflows/arma.yml">
        <img src="https://github.com/IDI-Systems/acre2/actions/workflows/arma.yml/badge.svg?branch=master" alt="ACRE2 Build Status">
    </a>
</p>

<p align="center">
    <sup><strong>Requires the latest version of <a href="https://github.com/CBATeam/CBA_A3/releases">CBA A3</a>.<br/></strong></sub>
</p>

**ACRE2** is a full fledged communications suite for Arma 3, allowing realistic radio and voice communications through TeamSpeak 3.

The project is entirely **open-source** and all contributions are welcome. Core project is licensed under GNU General Public License ([GPLv3](https://github.com/IDI-Systems/acre2/blob/master/LICENSE)). Some folders may contain a separate LICENSE file, specifying differently licensed items.

### Features

- Accurate simulations of AN/PRC-343, AN/PRC-77, AN/PRC-148, AN/PRC-117F, AN/PRC-152, SEM 52 SL, SEM 70, BF-888S.
- Vehicle racks AN/VRC-64, AN/VRC-103, AN/VRC-110, AN/VRC-111, SEM90.
- Deployable antennas.
- Real time voice occlusion for world objects, including buildings.
- Babel language system that allows you to implement virtual languages on other players.
- Multi-channel audio, allowing people on the radio to be heard locally as well.
- Radios with external speakers.
- Possibility to share owned radios with other players.
- Highly detailed radio signal simulation.
- Zeus and spectator modes integration.
- Multiple signal propagation models: Arcade, LOS Single path, LOS Multipath (default) and, experimentally, the Longley-Rice (ITM) model.
- A highly customizable and documented framework for the creation of radios.
- A highly customizable and documented framework for implementing different game modes (persistent world, replays, logging, external data storage, external radio control).
- A highly customizable and documented framework for implementing intercom systems and infantry phones.
- A highly customizable and documented framework for implementing vehicle racks and their integration into the intercom system.
- Customizable sound configs that allow traditional patching of sounds played in ACRE via Arma addons.
- Customizable radio presets, allowing mission makers to define radio presets as well as an API to take advantage of (as an example see the ACRE2 implementation in the [TMF](https://github.com/TMF3/TMF)).
- Enhanced and easily configurable vehicle sound occlusion.
- Ground spike antenna for improved signal quality.

### Guides

If you installed ACRE2 but have trouble understanding how it all works, or where to start, read this first:
- [Installation Instructions](https://acre2.idi-systems.com/wiki/user/installation)
- [Documentation Home](https://acre2.idi-systems.com)
